#!/bin/sh
#export SPARK_HOME=/data/liukai/spark
#export PATH=$PATH:$SPARK_HOME/bin
# # # # # # # # # # # # # # # # # # # # # #
# @author : 刘凯
# @date : 2018-01-16s
# @desc : 3s中抽取app info adr 数据
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
date_path=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")


OUTPUT_PATH="${DIM_APP_INFO_ADR}/$date_path/3s"
## JAR="DMP.jar"

check_await "s3://mob-emr-test/leo.liang/dmp_dummper/all_3s_android.json.log"

#--deploy-mode cluster 
spark-submit --class mobvista.dmp.datasource.app_info_tag.App_info_adr_3s \
 --conf spark.yarn.executor.memoryOverhead=2048  --conf spark.network.timeout=720s \
 --master yarn --deploy-mode cluster --name app_info_adr_3s --conf spark.app.loadTime=${LOG_TIME} --conf spark.app.output_path=${OUTPUT_PATH} --executor-memory 6g --driver-memory 4g --executor-cores 2 --num-executors 30 \
 ../${JAR}
if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "dim_app_info_adr_category" "year='${LOG_TIME:0:4}', month='${LOG_TIME:4:2}', day='${LOG_TIME:6:2}', business='3s'" "$OUTPUT_PATH"