#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :app_tag.sh
# @desc    :app_tag job
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

output_path="s3://mob-emr-test/dataplatform/data/app_tag"

spark-submit --class mobvista.dmp.datasource.apptag.AppTagJob \
     --name "AppTagJob" \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --conf dfs.socket.timeout=300000 \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 2 \
     ../${JAR} -output ${output_path}

if [[ $? -ne 0 ]]; then
    exit 255
fi