#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @author  :wangjf
# @revision:2019-09-03 11:13:18
# # # # # # # # # # # # # # # # # # # # # #

source ../../dmp_env.sh

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")

host="ip-172-31-20-35.ec2.internal"
cluster="cluster_1st"
database="dwh"
table="adn_tracking_daily"

spark-submit --class mobvista.dmp.clickhouse.tracking.AdnTrackingDaily \
     --name "AdnTrackingDaily_wangjf_${date}" \
     --conf spark.sql.shuffle.partitions=10 \
     --conf spark.default.parallelism=10 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 5 \
     ../../${JAR} -date ${date} -host ${host} -cluster ${cluster} -database ${database} -table ${table}

if [[ $? -ne 0 ]]; then
    exit 255
fi