#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @author  :wangjf
# @revision:2019-09-03 11:01:42
# # # # # # # # # # # # # # # # # # # # # #

source ../../dmp_env.sh

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")

INTPUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_user_info/${date_path}"

check_await ${INTPUT}/_SUCCESS

sleep 60

host="ip-172-31-20-35.ec2.internal"
cluster="cluster_1st"
database="dwh"
table="ods_user_info"

# --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
# --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
spark-submit --class mobvista.dmp.clickhouse.feature.UserInfo \
     --name "UserInfo_wangjf_${date}" \
     --conf spark.sql.shuffle.partitions=10000 \
     --conf spark.default.parallelism=10000 \
     --conf spark.sql.files.maxPartitionBytes=134217728 \
     --conf spark.kryoserializer.buffer.max=512m \
     --conf spark.kryoserializer.buffer=64m \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --master yarn --deploy-mode cluster --executor-memory 8g --driver-memory 4g  --executor-cores 4  --num-executors 10 \
     ../../${JAR} -date ${date} -host ${host} -cluster ${cluster} -database ${database} -table ${table}

if [[ $? -ne 0 ]]; then
    exit 255
fi