#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :dm_interest_tag_all_v2.sh
# @author  :wangjf
# @revision:2018-12-27 11:13:06
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")
year=${date:0:4}
month=${date:4:2}
day=${date:6:2}
ga_date=$(date +"%Y%m%d" -d "-2 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")

ADN_INSTALL_INPUT="${DMP_INSTALL_LIST}/${date_path}/adn_install"
ADN_REQUEST_INPUT="${DMP_INSTALL_LIST}/${date_path}/adn_request_sdk"
ADN_REQUEST_OTHER_INPUT="${DMP_INSTALL_LIST}/${date_path}/adn_request_other"
DSP_REQUEST_INPUT="${DMP_INSTALL_LIST}/${date_path}/dsp_req"
INSTALL_3S_INPUT="${DMP_INSTALL_LIST}/${date_path}/3s"
MP_INSTALL_INPUT="${DMP_INSTALL_LIST}/${date_path}/mp"
CLEVER_INSTALL_INPUT="${DMP_INSTALL_LIST}/${date_path}/clever"
ADN_SDK_INPUT="${DMP_INSTALL_LIST}/${date_path}/adn_sdk"

# OTHER_INPUT="${DMP_INSTALL_LIST}/$old_date_path/other"
# GA_INSTALL_INPUT=$(get_recently_dir "${DMP_INSTALL_LIST}" "${TWO_DAYS_AGO}" "ga")
# GA_DEVICE_INPUT=$(get_recently_dir "${DMP_INSTALL_LIST}" "${TWO_DAYS_AGO}" "ga_device")

check_await ${ADN_INSTALL_INPUT}/_SUCCESS
check_await ${ADN_REQUEST_INPUT}/_SUCCESS
check_await ${ADN_REQUEST_OTHER_INPUT}/_SUCCESS
check_await ${DSP_REQUEST_INPUT}/_SUCCESS
check_await ${INSTALL_3S_INPUT}/_SUCCESS
check_await ${MP_INSTALL_INPUT}/_SUCCESS
check_await ${CLEVER_INSTALL_INPUT}/_SUCCESS
check_await ${ADN_SDK_INPUT}/_SUCCESS

OUTPUT_PATH="${DM_DEV_INTEREST_PATH}_orc/${year}/${month}/${day}/all"

spark-submit --class mobvista.dmp.datasource.dm.DmpDeviceInterest \
     --name "DmpDeviceInterest.${date}" \
     --conf spark.sql.shuffle.partitions=4000 \
     --conf spark.default.parallelism=4000 \
     --conf spark.kryoserializer.buffer.max=512m \
     --conf spark.kryoserializer.buffer=64m \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.sql.files.maxPartitionBytes=268435456 \
     --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 4g  --executor-cores 4  --num-executors 100 \
     ../${JAR} \
     -date ${date} -output ${OUTPUT_PATH}

if [[ $? -ne 0 ]]; then
    exit 255
fi

common_mount_partition "dev" "dm_interest_tag_orc" "year='$year', month='$month', day='$day', business='all'" "$OUTPUT_PATH"