#!/bin/bash

source ../dmp_env.sh

keyspace="mapping"

table="mapping_server"

region="sg"

spark-submit --class mobvista.dmp.datasource.backflow.MappingServer \
  --name "MappingServer.${keyspace}.${table}.${region}" \
  --conf spark.sql.shuffle.partitions=1000 \
  --conf spark.default.parallelism=1000 \
  --conf spark.kryoserializer.buffer.max=512m \
  --conf spark.kryoserializer.buffer=64m \
  --master yarn --deploy-mode cluster \
  --executor-memory 8g --driver-memory 8g --executor-cores 5 --num-executors 20 \
  .././DMP.jar \
  -keyspace ${keyspace} -table ${table} -region ${region}

if [[ $? -ne 0 ]]; then
  exit 255
fi
