#!/usr/bin/env bash
source ../../dmp_env.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
dt_day=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_day=$(date -d "$ScheduleTime" +"%Y/%m/%d")


check_await "${DM_INSTALL_LIST}_v2/${dt_slash_today}/dsp_req/_SUCCESS"
check_await "${DM_INSTALL_LIST}_v2/${dt_slash_today}/btop/_SUCCESS"
check_await "${DM_INSTALL_LIST}_v2/${dt_slash_day}/TO/_SUCCESS"

OUTPUT_PATH1="${RTDMP_TMP_PACKAGE_NAME_PATH}/adx_packagename_synchronize/${dt_slash_today}/"
hadoop fs -rm -r "${OUTPUT_PATH1}"


spark-submit --class mobvista.dmp.datasource.dm.AdxPackagenameSynchronize \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.default.parallelism=3000 \
 --conf spark.sql.shuffle.partitions=3000 \
 --conf spark.driver.maxResultSize=4g \
 --conf spark.network.timeout=720s \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 6g  --executor-cores 5  --num-executors 50 \
 ../../${JAR} -dt_today ${dt_today}    -output1 ${OUTPUT_PATH1} \
 -dt_day ${dt_day} \
 -coalesce 300


if [[ $? -ne 0 ]]; then
    exit 255
fi



: '
任务说明
把下面这些安装包名的写到s3路径，并提供给@梁晓鹏 Leo Liang @李林梦 Linmeng Li ，入库RTDMP。一共应该是14个人群包，入库的人群包名称后面如果有括号的话可以用括号里的人群包名称（括号内的名称比较好理解），
实际dmp中的包名是括号外的，所以代码使用括号外的人群包进行设备筛选
Business=dsp_req下：
id3876827262021090301（id387682726_bes）
id3332062892021090301（id333206289_bes）
id13403763232021090301（id1340376323_bes）
id10442830592021090301（id1044283059_bes）
com.xunmeng.pinduoduo_bes
com.ss.android.ugc.aweme_iqiyi
id11421108952021090302（id1142110895_iqiyi）
com.xunmeng.pinduoduo_oppoziyou
com.xunmeng.pinduoduo_oppoziyou_notinstall
com.xunmeng.pinduoduo_oppoziyou_hist_notinstall
com.xunmeng.pinduoduo_oppolianmeng
com.xunmeng.pinduoduo_oppolianmeng_hist1year_notinstall
com.xunmeng.pinduoduo_oppolianmeng_histhalfyear_notinstall
Business=btop&TO下
com.xunmeng.pinduoduo（com.xunmeng.pinduoduo_btop)
'