#!/usr/bin/env bash

source ../../dmp_env.sh

begin_day=$(date -d "$ScheduleTime 15 days ago" +"%Y%m%d")
begin_day02=$(date -d "$ScheduleTime 30 days ago" +"%Y%m%d")
end_day=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_dash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")


check_await "${TMP_EGGPLANTS_OUTPUT_PATH}/${dt_dash_today}"

hadoop fs -test -e "${ODS_OTHER_DEVICE_DAILY}/${dt_dash_today}"
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p "${ODS_OTHER_DEVICE_DAILY}/${dt_dash_today}"
fi


OUTPUT_PATH01="${TMP_COM_BTOP_TIKTOKRV_PATH}/${dt_dash_today}/01"
OUTPUT_PATH02="${TMP_COM_BTOP_TIKTOKRV_PATH}/${dt_dash_today}/02"
OUTPUT_PATH03="${RTDMP_TMP_PACKAGE_NAME_PATH}/com_btop_tiktokrv/${dt_dash_today}/imei"
OUTPUT_PATH04="${RTDMP_TMP_PACKAGE_NAME_PATH}/com_btop_tiktokrv/${dt_dash_today}/oaid"
hadoop fs -rm -r "${OUTPUT_PATH01}"
hadoop fs -rm -r "${OUTPUT_PATH02}"
hadoop fs -rm -r "${OUTPUT_PATH03}"
hadoop fs -rm -r "${OUTPUT_PATH04}"

spark-submit --class mobvista.dmp.datasource.dm.BtopTiktokrv \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.default.parallelism=3000 \
 --conf spark.sql.shuffle.partitions=3000 \
 --conf spark.network.timeout=720s \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 12g  --executor-cores 5  --num-executors 70 \
 ../../${JAR} -begin_day ${begin_day}   -begin_day02 ${begin_day02}  -end_day ${end_day} -output01 ${OUTPUT_PATH01}  -output02 ${OUTPUT_PATH02}  -output03 ${OUTPUT_PATH03} -output04 ${OUTPUT_PATH04} -coalesce 200


if [[ $? -ne 0 ]]; then
    exit 255
fi

hadoop distcp -m20  "${OUTPUT_PATH01}/*" "${TMP_EGGPLANTS_OUTPUT_PATH}/${dt_dash_today}/"
hadoop distcp -m20  "${OUTPUT_PATH02}/*" "${ODS_OTHER_DEVICE_DAILY}/${dt_dash_today}/"
