#!/usr/bin/env bash
# 从dm_install_list_v2表在reyun分区里的com.eg.android.AlipayGphone设备拉出来到某个路径里（天级别更新）, 后续需要把这个人群包入rtdmp，命名为com.eg.android.AlipayGphone_reyun
# 获取下面这2个包名在business=btop(topon）和reyun（热云）的设备入人群包数据库  com.taobao.litetao  com.ss.android.ugc.aweme
# 人群包名称可以叫 com.taobao.litetao_reyun com.ss.android.ugc.aweme_reyun com.taobao.litetao_btop com.ss.android.ugc.aweme_btop

source ../../dmp_env.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
update=$(date -d "$ScheduleTime 15 days ago" +"%Y-%m-%d")
update02=$(date -d "$ScheduleTime 3 days ago" +"%Y-%m-%d")

check_await "${TMP_EGGPLANTS_OUTPUT_PATH}/${dt_slash_today}"

hadoop fs -test -e "${ODS_OTHER_DEVICE_DAILY}/${dt_slash_today}"
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p "${ODS_OTHER_DEVICE_DAILY}/${dt_slash_today}"
fi

business1="reyun"
INPUT_PATH1="${DM_INSTALL_LIST}_v2/${dt_slash_today}/${business1}"
check_await ${INPUT_PATH1}/_SUCCESS

business2="btop"
INPUT_PATH2="${DM_INSTALL_LIST}_v2/${dt_slash_today}/${business2}"
check_await ${INPUT_PATH2}/_SUCCESS

business3="dsp_req"
INPUT_PATH3="${DM_INSTALL_LIST}_v2/${dt_slash_today}/${business3}"
check_await ${INPUT_PATH3}/_SUCCESS

OUTPUT_PATH1="${RTDMP_TMP_PACKAGE_NAME_PATH}/btop_reyun_to_other/${dt_slash_today}/01"
OUTPUT_PATH2="${RTDMP_TMP_PACKAGE_NAME_PATH}/btop_reyun_to_other/${dt_slash_today}/02"
hadoop fs -rm -r "${OUTPUT_PATH1}"
hadoop fs -rm -r "${OUTPUT_PATH2}"


spark-submit --class mobvista.dmp.datasource.dm.ComEgAndroidAlipayGphoneReyun \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.default.parallelism=3000 \
 --conf spark.sql.shuffle.partitions=3000 \
 --conf spark.driver.maxResultSize=4g \
 --conf spark.network.timeout=720s \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 6g  --executor-cores 5  --num-executors 20 \
 ../../${JAR} -dt_today ${dt_today}    -output1 ${OUTPUT_PATH1}  -output2 ${OUTPUT_PATH2} -update ${update}  -update02 ${update02} \
  -coalesce 200


if [[ $? -ne 0 ]]; then
    exit 255
fi

hadoop distcp -m20  "${OUTPUT_PATH1}/*" "${TMP_EGGPLANTS_OUTPUT_PATH}/${dt_slash_today}/"
hadoop distcp -m20  "${OUTPUT_PATH2}/*" "${ODS_OTHER_DEVICE_DAILY}/${dt_slash_today}/"

: '
业务说明：
将这五个伪包名设备
com.eg.android.AlipayGphone_reyun
com.taobao.litetao_reyun
com.ss.android.ugc.aweme_reyun
com.taobao.litetao_btop
com.ss.android.ugc.aweme_btop
天级别入库dmp的business=other分区
更新
获取过去3天的爱奇艺淘宝安装包名的设备入库，针对com.taobao.taobao_iqiyi，
限制过去三天活跃的设备伪包名入库。人群包名称可定为com.taobao.taobao_iqiyi_3
'