#!/usr/bin/env bash

source ../../dmp_env.sh

first_day=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
second_day=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")


check_await "${TMP_EGGPLANTS_OUTPUT_PATH}/${dt_slash_today}"

hadoop fs -test -e "${ODS_OTHER_DEVICE_DAILY}/${dt_slash_today}"
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p "${ODS_OTHER_DEVICE_DAILY}/${dt_slash_today}"
fi


OUTPUT_PATH01="${TMP_COM_LAZADA_NOREGISTER_70P_30P_PATH}/${dt_slash_today}/01"
OUTPUT_PATH02="${TMP_COM_LAZADA_NOREGISTER_70P_30P_PATH}/${dt_slash_today}/02"
hadoop fs -rm -r "${OUTPUT_PATH01}"
hadoop fs -rm -r "${OUTPUT_PATH02}"

spark-submit --class mobvista.dmp.datasource.dm.ComLazadaNoregister70p30p \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.default.parallelism=2000 \
 --conf spark.sql.shuffle.partitions=2000 \
 --conf spark.driver.maxResultSize=4g \
 --conf spark.network.timeout=720s \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 6g  --executor-cores 5  --num-executors 20 \
 ../../${JAR} -first_day ${first_day}   -second_day ${second_day}  -output01 ${OUTPUT_PATH01}  -output02 ${OUTPUT_PATH02}   -coalesce 200


if [[ $? -ne 0 ]]; then
    exit 255
fi

hadoop distcp -m20  "${OUTPUT_PATH01}/*" "${TMP_EGGPLANTS_OUTPUT_PATH}/${dt_slash_today}/"
hadoop distcp -m20  "${OUTPUT_PATH02}/*" "${ODS_OTHER_DEVICE_DAILY}/${dt_slash_today}/"


: '
任务说明
每天用前一天的安装，如20211111 串 前一天 - 今天的注册事件，如20211111-20211112，eventname限制为event_name = "REGISTRATION"，并把串不到注册的设备id 按照 7:3 比例随机分成两个人群包更新
'