#!/usr/bin/env bash

source ../../dmp_env.sh
source ./../../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
update_date=$(date -d "$ScheduleTime 7 days ago" +"%Y-%m-%d")

INPUT_PATH1="${DM_INSTALL_LIST}_v2/${dt_slash_today}/reyun"
check_await ${INPUT_PATH1}/_SUCCESS

check_await "${TMP_EGGPLANTS_OUTPUT_PATH}/${dt_slash_today}"

hadoop fs -test -e "${ODS_OTHER_DEVICE_DAILY}/${dt_slash_today}"
if [ $? -ne 0 ];then
  hadoop fs -mkdir -p "${ODS_OTHER_DEVICE_DAILY}/${dt_slash_today}"
fi


OUTPUT_PATH01="${TMP_REYUN_LAHUO_LIST_PATH}/${dt_slash_today}/01"
OUTPUT_PATH02="${TMP_REYUN_LAHUO_LIST_PATH}/${dt_slash_today}/02"

hadoop fs -rm -r "${OUTPUT_PATH01}"
hadoop fs -rm -r "${OUTPUT_PATH02}"

spark-submit --class mobvista.dmp.datasource.dm.ReyunLahuoList \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.default.parallelism=3000 \
 --conf spark.sql.shuffle.partitions=3000 \
 --conf spark.network.timeout=720s \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 4g  --executor-cores 5  --num-executors 10 \
 ../../${JAR} -dt_today ${dt_today}  -output01 ${OUTPUT_PATH01}  -output02 ${OUTPUT_PATH02}  -update_date ${update_date}\
  -coalesce 200


if [[ $? -ne 0 ]]; then
    exit 255
fi

hadoop distcp -m20  "${OUTPUT_PATH01}/*" "${TMP_EGGPLANTS_OUTPUT_PATH}/${dt_slash_today}/"
hadoop distcp -m20  "${OUTPUT_PATH02}/*" "${ODS_OTHER_DEVICE_DAILY}/${dt_slash_today}/"


: '
需求说明
取reyun分区下列六个包最近七天的的数据入库安装列表other分区
"com.ss.android.ugc.aweme","com.taobao.idlefish","com.taobao.taobao","com.UCMobile","com.xunmeng.pinduoduo","me.ele"
'