#!/usr/bin/env bash
source ../../dmp_env.sh

dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_slash_today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")


check_await "${DM_INSTALL_LIST}_v2/${dt_slash_today}/dsp_req/_SUCCESS"

OUTPUT_PATH1="${RTDMP_TMP_PACKAGE_NAME_PATH}/id1142110895/${dt_slash_today}/"
hadoop fs -rm -r "${OUTPUT_PATH1}"


spark-submit --class mobvista.dmp.datasource.dm.RtdmpTmpId1142110895 \
  --conf spark.yarn.executor.memoryOverhead=2048 \
  --conf spark.default.parallelism=10000 \
  --conf spark.sql.shuffle.partitions=10000 \
  --conf spark.driver.maxResultSize=4g \
  --conf spark.network.timeout=720s \
  --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 6g --executor-cores 5 --num-executors 80 \
  ../../${JAR} -dt_today ${dt_today} -output1 ${OUTPUT_PATH1} \
  -coalesce 400


if [[ $? -ne 0 ]]; then
    exit 255
fi