#!/bin/sh
source ../dmp_env.sh

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")

# dwh.ods_dmp_event_org

spark-submit --class mobvista.dmp.datasource.newtag.CalInterestTag \
      --conf spark.network.timeout=720s \
      --conf spark.sql.broadcastTimeout=1200\
      --master yarn --deploy-mode cluster --executor-cores 2 --driver-memory 4g --executor-memory 6G  --num-executors 1 \
      ../${JAR} \
      -today ${date}

if [[ $? -ne 0 ]];then
  exit 255
fi
