# !/bin/sh
source ./tools.sh
source ../dmp_env.sh


today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")

expire_date=$(date -d "$ScheduleTime 91 days ago" +"%Y%m%d")
expire_date_path=$(date -d "$ScheduleTime 91 days ago" +"%Y/%m/%d")
echo ${today}
echo ${yesterday}

: '
#由日期获得上周日日期
week=`date -d "$today" +%w`
echo "week=$week"
if [ "$week" -eq "0" ];then
 week=7 #若为周日，则表示为7
fi
if [ "$week" -eq "1" ];then
 week=8 #若为周一，则表示为8，取上上周日数据
fi
last_sunday=$(date +%Y%m%d -d "-$week day $today")
'

business='allpb'

POSTBACK_EVENT_3S="${POSTBACK_EVENT_3S_PATH}/${today}/virginia/23/_SUCCESS"
OUTPUT_PATH="${ODS_DMP_EVENT_ORG}/${today}/${business}"
EXPIRE_PATH="${ODS_DMP_EVENT_ORG}/${expire_date_path}/${business}"

check_await "${POSTBACK_EVENT_3S}"
check_await "${DEVICE_ID_MD5_MATCH_PATH}/${yesterday}/_SUCCESS"

hadoop fs -rm -r "$OUTPUT_PATH/"

spark-submit --class mobvista.dmp.datasource.event_tag.PostBackEvent \
 --conf spark.yarn.executor.memoryOverhead=2048  \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=1000 \
 --conf spark.sql.shuffle.partitions=1000 \
 --conf spark.sql.broadcastTimeout=1200 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --conf spark.sql.adaptive.enabled=true \
 --conf spark.sql.adaptive.advisoryPartitionSizeInBytes=268435456 \
 --jars s3://mob-emr-test/dataplatform/DataWareHouse/offline/myjar/hive-hcatalog-core-2.3.3.jar \
 --master yarn --deploy-mode cluster  --executor-memory 8g --driver-memory 6g  --executor-cores 4 --num-executors 50 \
 ../${JAR} -output ${OUTPUT_PATH}  -coalesce 200 \
 -today ${dt_today}  -last_sunday ${dt_yesterday}

if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "ods_dmp_event_org" "dt='${dt_today}',business='${business}'" "$OUTPUT_PATH"

# 删除过期的分区及删除对应路径
unmount_partition "ods_dmp_event_org" "dt='${expire_date}',business='${business}'" "${EXPIRE_PATH}"

: '
export HIVE_CONF_DIR=/data/azkaban-hadoop/command-home/hive-offline/conf

HIVE_CMD=$(hive_func)
$HIVE_CMD	  -v  -hivevar	today=${dt_today}  -hivevar  last_sunday=${last_sunday}  -f	event_3s_postback_tag.sql

if [ $? -ne 0 ]; then
    exit 255
fi
'
hadoop fs -touchz ${OUTPUT_PATH}/_SUCCESS

