# !/bin/sh
source ../dmp_env.sh
source ./tools.sh

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")
date_underline=$(date +%Y_%m_%d -d "-1 day $today")

business='ga'

GA_RAW_SRC_DATA_PATH="${GA_ODS_RAW_DATA_PATH}/${date_path}"
check_await "${GA_RAW_SRC_DATA_PATH}/_SUCCESS"

## OUTPUT_PATH="${ODS_DMP_EVENT_ORG}/${date_path}/${business}"
OUTPUT_EVENT_TAG_PATH="${ODS_DMP_EVENT_TAG}/${date_path}/${business}"

# dwh.ods_dmp_event_org
hadoop fs -rmr ${OUTPUT_EVENT_TAG_PATH}

spark-submit --class mobvista.dmp.datasource.event_tag.DmpGaEventTag \
  --conf spark.serializer=org.apache.spark.serializer.KryoSerializer \
  --conf spark.sql.shuffle.partitions=20000 \
  --conf spark.network.timeout=1200 \
  --conf spark.shuffle.compress=true \
  --conf spark.shuffle.spill.compress=true \
  --name dmp_ga_event_tag \
  --jars s3://mob-emr-test/dataplatform/DataWareHouse/offline/myjar/json-serde-1.3.7-jar-with-dependencies.jar \
  --master yarn --deploy-mode cluster --driver-memory 4g --executor-cores 2 --executor-memory 4G --num-executors 160 \
  ../${JAR} \
  -today ${date} -today_underline ${date_underline} -output ${OUTPUT_EVENT_TAG_PATH} -coalesce 400

if [[ $? -ne 0 ]]; then
  exit 255
fi

## mount_partition "ods_dmp_event_org" "dt='${date}',business='ga'" "$OUTPUT_PATH"

mount_partition "ods_dmp_event_tag" "dt='${date}',business='ga'" "$OUTPUT_EVENT_TAG_PATH"

# HIVE_CMD=$(hive_func)
# $HIVE_CMD	-e "insert overwrite table dwh.ods_dmp_event_tag partition(dt='${date}',business='ga') select device_id,uuid,platform,device_type,country,package_name,first_tag,second_tag,pursub,update_date from dwh.ods_dmp_event_org where dt='${date}' and business = 'ga' group by device_id,uuid,platform,device_type,country,package_name,first_tag,second_tag,pursub,update_date"
#
# hadoop fs -touchz ${OUTPUT_PATH}/_SUCCESS
