#!/bin/bash

source ../dmp_env.sh

ScheduleTime=${ScheduleTime:-$1}
dt=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")
date_path=$(date -d "$ScheduleTime 1 days ago" "+%Y/%m/%d")

INPUT_DSP_PATH="${ETL_DSP_REQ_ETL_HOURS}/$date_path"

check_await "${INPUT_DSP_PATH}/23/_SUCCESS"

OUTPUT="${DSP_DEVICE_MAPPING}/${date_path}"

spark-submit --class mobvista.dmp.datasource.dsp.DspDeviceIdMapping \
  --name "DspDeviceIdMapping.${dt}" \
  --conf spark.sql.shuffle.partitions=10000 \
  --conf spark.default.parallelism=10000 \
  --conf spark.kryoserializer.buffer.max=256m \
  --conf spark.sql.files.maxPartitionBytes=536870912 \
  --conf spark.sql.adaptive.enabled=true \
  --conf spark.sql.adaptive.advisoryPartitionSizeInBytes=536870912 \
  --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 6g --executor-cores 5 --num-executors 100 \
  ../${JAR} -date ${dt} -output ${OUTPUT} -coalesce 100

if [[ $? -ne 0 ]]; then
  exit 255
fi
