#!/bin/sh

source ../../dmp_env.sh

ScheduleTime=${ScheduleTime:-$1}
cur_date=$(date -d "$ScheduleTime 1 days ago" "+%Y%m%d")
cur_date_path=$(date -d "$ScheduleTime 1 days ago" "+%Y/%m/%d")
begin_date=$(date -d "$ScheduleTime 4 days ago" "+%Y%m%d")


OUTPUT_PATH=$ADN_DSP_CLICK/${cur_date_path}

CPCOUTPUT_PATH=${OUTPUT_PATH}/cpc
CPMOUTPUT_PATH=${OUTPUT_PATH}/cpm
CPIOUTPUT_PATH=${OUTPUT_PATH}/cpi


hadoop fs -test -e ${OUTPUT_PATH}
if [ $? -ne 0 ];then
hadoop fs -mkdir -p  ${OUTPUT_PATH}
fi

 hadoop fs -rmr ${CPCOUTPUT_PATH}
 hadoop fs -rmr ${CPMOUTPUT_PATH}
 hadoop fs -rmr ${CPIOUTPUT_PATH}



spark-submit --class  mobvista.dmp.datasource.dsp.DspClickImpressionCombineOrc \
     --name "mobvista.dmp.datasource.dsp.DspClickImpressionCombineOrc" \
	--conf spark.sql.shuffle.partitions=4000 \
	--conf spark.default.parallelism=4000 \
	--conf spark.network.timeout=720s \
    --conf spark.sql.broadcastTimeout=1200 \
	 --conf spark.sql.files.maxPartitionBytes=268435456 \
     --conf spark.serializer=org.apache.spark.serializer.KryoSerializer \
	--master yarn \
	--deploy-mode cluster \
	--executor-memory 8G \
	--driver-memory 4G \
	--executor-cores 4 \
	--num-executors 40 \
	../../${JAR}  \
	-cur_date ${cur_date}  -begin_date ${begin_date} \
	-output ${OUTPUT_PATH}  -cpcoutput ${CPCOUTPUT_PATH} -cpmoutput ${CPMOUTPUT_PATH} -cpioutput ${CPIOUTPUT_PATH} -coalesce 2000

if [ $? -ne 0 ]; then
    exit 255
fi


common_mount_partition "adn_dsp" "log_adn_dsp_click_day" "day='${cur_date}', billing_type='cpc'" "${CPCOUTPUT_PATH}"
common_mount_partition "adn_dsp" "log_adn_dsp_click_day" "day='${cur_date}', billing_type='cpi'" "${CPIOUTPUT_PATH}"
common_mount_partition "adn_dsp" "log_adn_dsp_click_day" "day='${cur_date}', billing_type='cpm'" "${CPMOUTPUT_PATH}"

hadoop fs -touchz ${CPCOUTPUT_PATH}/_SUCCESS
hadoop fs -touchz ${CPIOUTPUT_PATH}/_SUCCESS
hadoop fs -touchz ${CPMOUTPUT_PATH}/_SUCCESS


