#!/bin/sh

source ../../dmp_env.sh


ScheduleTime=${ScheduleTime:-$1}
starttime=$(date -d "4 hours ago $ScheduleTime" "+%Y%m%d%H")
endtime=$(date -d "1 hours ago $ScheduleTime" "+%Y%m%d%H")

datapath=$(date -d "1 hours ago $ScheduleTime" "+%Y/%m/%d")
yearpath=$(date -d "1 hours ago $ScheduleTime" "+%Y")
mothpath=$(date -d "1 hours ago $ScheduleTime" "+%m")
daypath=$(date -d "1 hours ago $ScheduleTime" "+%d")
hhpath=$(date -d "1 hours ago $ScheduleTime" "+%H")



## CNOUTPUT_PATH=s3://mob-emr-test/andy/log_adn_dsp_impression_hour_test/${datapath}/cn/${hhpath}

CNOUTPUT_PATH=s3://mob-ad/adn/dsp/impression/${datapath}/cn/${hhpath}


hadoop fs -test -e ${CNOUTPUT_PATH}
if [ $? -ne 0 ];then
hadoop fs -mkdir -p  ${CNOUTPUT_PATH}
fi

dsp_impression_org_hour="s3://mob-ad/adn/dsp/impression_org/impression/${datapath}/cn/${hhpath}"
dsp_request_orc_hour_cn="s3://mob-ad/adn/dsp_orc/bid_request/${datapath}/cn/${hhpath}"

check_await "${dsp_impression_org_hour}/_SUCCESS"
check_await "${dsp_request_orc_hour_cn}/_SUCCESS"

common_mount_partition "adn_dsp" "log_adn_dsp_impression_org_hour" "yr='${yearpath}', mt='${mothpath}',dt='${daypath}',rg='cn',hh='${hhpath}'" "${dsp_impression_org_hour}"
common_mount_partition "adn_dsp" "log_adn_dsp_bid_request_orc_hour" "yr='${yearpath}', mt='${mothpath}',dt='${daypath}',rg='cn',hh='${hhpath}'" "${dsp_request_orc_hour_cn}"

hadoop fs -rmr ${CNOUTPUT_PATH}

spark-submit --class  mobvista.dmp.datasource.dsp.DspImpressionHourFullCn \
     --name "mobvista.dmp.datasource.dsp.DspImpressionHourFullCn" \
	--conf spark.sql.shuffle.partitions=6 \
	--conf spark.default.parallelism=6 \
	--conf spark.serializer=org.apache.spark.serializer.KryoSerializer \
	--conf spark.yarn.executor.memoryOverhead=1024 \
	--master yarn \
	--deploy-mode cluster \
	--executor-memory 2G \
	--driver-memory 1G \
	--executor-cores 2 \
	--num-executors 5 \
	../../${JAR}  \
	-starttime ${starttime}  -endtime ${endtime} -output ${CNOUTPUT_PATH}

if [ $? -ne 0 ]; then
    exit 255
fi

common_mount_partition "adn_dsp" "log_adn_dsp_impression_hour" "yr='${yearpath}', mt='${mothpath}',dt='${daypath}',rg='cn',hh='${hhpath}'" "${CNOUTPUT_PATH}"

hadoop fs -touchz ${CNOUTPUT_PATH}/_SUCCESS

