#!/bin/sh

source ../../dmp_env.sh


ScheduleTime=${ScheduleTime:-$1}
starttime=$(date -d "4 hours ago $ScheduleTime" "+%Y%m%d%H")
endtime=$(date -d "1 hours ago $ScheduleTime" "+%Y%m%d%H")

datapath=$(date -d "1 hours ago $ScheduleTime" "+%Y/%m/%d")
yearpath=$(date -d "1 hours ago $ScheduleTime" "+%Y")
mothpath=$(date -d "1 hours ago $ScheduleTime" "+%m")
daypath=$(date -d "1 hours ago $ScheduleTime" "+%d")
hhpath=$(date -d "1 hours ago $ScheduleTime" "+%H")


dsp_impression_virginia_hour="s3://mob-ad/adn/dsp/impression_org/impression/${datapath}/virginia/${hhpath}"
dsp_request_orc_hour_virginia="s3://mob-ad/adn/dsp_orc/bid_request/${datapath}/virginia/${hhpath}"


check_await "${dsp_impression_virginia_hour}/_SUCCESS"
check_await "${dsp_request_orc_hour_virginia}/_SUCCESS"

common_mount_partition "adn_dsp" "log_adn_dsp_impression_org_hour" "yr='${yearpath}', mt='${mothpath}',dt='${daypath}',rg='virginia',hh='${hhpath}'" "${dsp_impression_virginia_hour}"
common_mount_partition "adn_dsp" "log_adn_dsp_bid_request_orc_hour" "yr='${yearpath}', mt='${mothpath}',dt='${daypath}',rg='virginia',hh='${hhpath}'" "${dsp_request_orc_hour_virginia}"

## VIRGINIAOOUTPUT_PATH=s3://mob-emr-test/andy/log_adn_dsp_impression_hour_test/${datapath}/virginia/${hhpath}

VIRGINIAOOUTPUT_PATH=s3://mob-ad/adn/dsp/impression/${datapath}/virginia/${hhpath}


hadoop fs -test -e ${VIRGINIAOOUTPUT_PATH}
if [ $? -ne 0 ];then
hadoop fs -mkdir -p  ${VIRGINIAOOUTPUT_PATH}
fi

hadoop fs -rmr ${VIRGINIAOOUTPUT_PATH}

spark-submit --class  mobvista.dmp.datasource.dsp.DspImpressionHourFullOther \
     --name "mobvista.dmp.datasource.dsp.DspImpressionHourFullOther.virginia" \
    --conf spark.sql.shuffle.partitions=2500 \
	--conf spark.default.parallelism=2500 \
	--conf spark.serializer=org.apache.spark.serializer.KryoSerializer \
	--conf spark.yarn.executor.memoryOverhead=2048 \
	--master yarn \
	--deploy-mode cluster \
	--executor-memory 6G \
	--driver-memory 3G \
	--executor-cores 3 \
	--num-executors 20 \
	../../${JAR}  \
	-starttime ${starttime}  -endtime ${endtime} -output ${VIRGINIAOOUTPUT_PATH} -region virginia

if [ $? -ne 0 ]; then
    exit 255
fi

common_mount_partition "adn_dsp" "log_adn_dsp_impression_hour" "yr='${yearpath}', mt='${mothpath}',dt='${daypath}',rg='virginia',hh='${hhpath}'" "${VIRGINIAOOUTPUT_PATH}"

hadoop fs -touchz ${VIRGINIAOOUTPUT_PATH}/_SUCCESS