#!/usr/bin/env bash

source ../dmp_env.sh

echo $TPScheduleTime
today=$(date -d "$TPScheduleTime 0 days ago" +"%Y/%m/%d")
yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
yes_bef3=$(date -d "$ScheduleTime 3 days ago" +"%Y/%m/%d")
dt_today=$(date -d "$TPScheduleTime 0 days ago" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")
dt_yes_bef3=$(date -d "$ScheduleTime 3 days ago" +"%Y%m%d")


echo ${today}
echo ${yesterday}

TP_DAILY_PATH="${BEHAVIOR_TP_DAILY}/${today}"
TP_TOTAL_PATH_YES="${BEHAVIOR_TP_TOTAL}/${yes_bef3}"
OUTPUT_TOTAL_PATH="${BEHAVIOR_TP_TOTAL}/${yesterday}"


check_await "${TP_TOTAL_PATH_YES}/_SUCCESS"
mount_partition "etl_behavior_thirdparty_data_daily" "dt='${dt_today}'" "${TP_DAILY_PATH}"


hadoop fs -rm -r "${OUTPUT_TOTAL_PATH}/"

spark-submit --class mobvista.dmp.datasource.behavior.ThirdPartySourceDaily \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=10 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --jars s3://mob-emr-test/dataplatform/DataWareHouse/offline/myjar/hive-hcatalog-core-2.3.3.jar \
 --master yarn --deploy-mode cluster --name behavior_from_third_party_daily --executor-memory 2g --driver-memory 4g  --executor-cores 2  --num-executors 2 \
 ../${JAR}  -outputtotal ${OUTPUT_TOTAL_PATH}  -coalesce 10 \
 -today ${dt_today} -yesbef3 ${dt_yes_bef3}


if [ $? -ne 0 ];then
  exit 255
fi


mount_partition "etl_behavior_thirdparty_data_total" "dt='${dt_yesterday}'" "${OUTPUT_TOTAL_PATH}"

hadoop fs -touchz ${OUTPUT_TOTAL_PATH}/_SUCCESS
