#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :fmp_insight.sh
# @desc    :fmp job
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh
data=$1
jobId=$2

output_path="s3://mob-emr-test/dataplatform/fmp/data/insight"

# --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
# --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
# --conf spark.memory.offHeap.enabled=true \
# --conf spark.memory.offHeap.size=6442450944 \
spark-submit --class mobvista.dmp.datasource.fmp.FmpInsightJob \
     --queue "fmp" \
     --name "mobvista.dmp.datasource.fmp.FmpInsightJob_wangjf" \
     --conf spark.sql.shuffle.partitions=1000 \
     --conf spark.default.parallelism=1000 \
     --conf spark.sql.broadcastTimeout=1200 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.yarn.executor.memoryOverhead=2048 \
     --conf spark.sql.files.maxPartitionBytes=134217728 \
     --conf spark.sql.adaptive.enabled=true \
     --conf spark.sql.adaptive.advisoryPartitionSizeInBytes=134217728 \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 6g  --executor-cores 5 --num-executors 64 \
     ../${JAR} \
     -data ${data// /###} -output ${output_path} -coalesce 1

if [[ $? -ne 0 ]]; then

    update_time=`date '+%Y-%m-%d %H:%M:%S'`

mysql -h dataplatform-app-tag.c5yzcdreb1xr.us-east-1.rds.amazonaws.com -P 3306 -u apptag_rw -p'7gyLEVtkER3u8c9' <<EOF
UPDATE dmp_fmp.job_profile SET update_time = '${update_time}', flag = 2 WHERE job_id = '${jobId}';
EOF
    exit 255

fi