#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :extract_device.sh
# @author  :liushuai
# @revision:2017-01-18 17:01
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

INPUT_PATH="${GENDER_MERGE_INSTALL}/${year}/${month}/${day}/"
OUTPUT_PATH="${GENDER_MERGE_DEVICE}/${year}/${month}/${day}/"
FILEDICT="${GENDER_CALC_PACKAGE_DICT}/${year}/${month}/${day}/part-00000"

RM_LOG_TIME=$(date +%Y/%m/%d -d "-10 day $ScheduleTime")
RM_DATE=$(date +%Y%m%d -d "-10 day $ScheduleTime")
RM_OUTPUT_PATH="${GENDER_MERGE_DEVICE}/${RM_LOG_TIME}"

spark-submit --class mobvista.dmp.datasource.age_gender.CalcDeviceGender \
     --name "CalcDeviceGender.${LOG_TIME}" \
     --conf spark.sql.shuffle.partitions=10000 \
     --conf spark.default.parallelism=2000 \
     --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
     --conf spark.storage.memoryFraction=0.4 \
     --conf spark.shuffle.memoryFraction=0.4 \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.sql.files.maxPartitionBytes=268435456 \
     --master yarn --deploy-mode cluster --executor-memory 8g --driver-memory 4g  --executor-cores 5  --num-executors 100 \
     ../${JAR} -date ${LOG_TIME} -merge_input ${INPUT_PATH} -dict_input ${FILEDICT} -output ${OUTPUT_PATH} -parallelism 500

if [[ $? -ne 0 ]]; then
    exit 255
fi

mount_partition "dmp_device_gender" "dt='$LOG_TIME'" "$OUTPUT_PATH"

unmount_partition "dmp_device_gender" "dt='$RM_DATE'" "${RM_OUTPUT_PATH}"

before_date_path=$(date +%Y/%m/%d -d "-3 day $ScheduleTime")
# 删除临时结果
hadoop fs -rm -r ${GENDER_GET_DSP_PATH}/${before_date_path}
hadoop fs -rm -r ${GENDER_GET_GA_PATH}/${before_date_path}
hadoop fs -rm -r ${GENDER_MERGE_INSTALL}/${before_date_path}
hadoop fs -rm -r ${GENDER_CALC_PACKAGE_DICT}/${before_date_path}

exit 0