#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :extract_device.sh
# @author  :liushuai
# @revision:2017-01-18 16:52
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

INPUT_PATH="${GENDER_MERGE_INSTALL}/${year}/${month}/${day}/"
OUTPUT_PATH="${GENDER_CALC_PACKAGE_DICT}/${year}/${month}/${day}/"
LOW=50
HIGH=50000
MALE_RATIO=0.85
FEMALE_RATIO=0.15

spark-submit --class mobvista.dmp.datasource.age_gender.CalcPackageGender \
     --name "CalcPackageGender.${LOG_TIME}" \
     --conf spark.default.parallelism=1000 \
     --conf spark.storage.memoryFraction=0.4 \
     --conf spark.shuffle.memoryFraction=0.4 \
     --conf spark.sql.files.maxPartitionBytes=134217728 \
     --master yarn --deploy-mode cluster --executor-memory 8g --driver-memory 4g  --executor-cores 4  --num-executors 100 \
     ../${JAR} -inputPath ${INPUT_PATH} -outputPath ${OUTPUT_PATH} -parallelism 1 \
     -lowThreshold ${LOW} -highThreshold ${HIGH} -mRatio ${MALE_RATIO} -fRatio ${FEMALE_RATIO}

if [[ $? -ne 0 ]]; then
    exit 255
fi