#!/usr/bin/env bash

source ../dmp_env.sh

today=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y/%m/%d")
dt_today=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_yesterday=$(date -d "$ScheduleTime 2 days ago" +"%Y%m%d")

umount_time=$(date -d "$ScheduleTime 5 days ago" +"%Y%m%d")
umount_date_path=$(date -d "$ScheduleTime 5 days ago" +"%Y/%m/%d")

echo ${today}
echo ${yesterday}


TP_TOTAL_PATH_YES="${GENDER_TP_TOTAL}/${yesterday}"
OUTPUT_TOTAL_PATH="${GENDER_TP_TOTAL}/${today}"
UMOUNT_OUTPUT_TOTAL_PATH="${GENDER_TP_TOTAL}/${umount_date_path}"
GENDER_OUTPUT_PATH="${GENDER_GET_THIRDPART_PATH}/${today}"
UMOUNT_GENDER_OUTPUT_PATH="${GENDER_GET_THIRDPART_PATH}/${umount_date_path}"


check_await "${TP_TOTAL_PATH_YES}/_SUCCESS"


hadoop fs -rm -r "${OUTPUT_TOTAL_PATH}/"
hadoop fs -rm -r "${GENDER_OUTPUT_PATH}/"

spark-submit --class mobvista.dmp.datasource.age_gender.ThirdPartySourceTotal \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=10 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --jars s3://mob-emr-test/dataplatform/DataWareHouse/offline/myjar/hive-hcatalog-core-2.3.3.jar \
 --master yarn --deploy-mode cluster --name gender_from_third_party --executor-memory 2g --driver-memory 2g  --executor-cores 2  --num-executors 3 \
 ../${JAR}  -outputtotal ${OUTPUT_TOTAL_PATH} -outputgender ${GENDER_OUTPUT_PATH} -coalesce 10  \
 -yesterday ${dt_yesterday}


if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "etl_gender_thirdparty_data_total" "dt='${dt_today}'" "${OUTPUT_TOTAL_PATH}"
unmount_partition "etl_gender_thirdparty_data_total" "dt='${umount_time}'" "${UMOUNT_OUTPUT_TOTAL_PATH}"

mount_partition "ods_gender_tp" "dt='${dt_today}'" "${GENDER_OUTPUT_PATH}"
unmount_partition "ods_gender_tp" "dt='${umount_time}'" "${UMOUNT_GENDER_OUTPUT_PATH}"

hadoop fs -touchz ${GENDER_OUTPUT_PATH}/_SUCCESS
hadoop fs -touchz ${OUTPUT_TOTAL_PATH}/_SUCCESS