#! /bin/bash

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
date_path=$(date +'%Y/%m/%d' -d "-1 day $ScheduleTime")

# INPUT_PATH=${ETL_DSP_REQ_ETL_HOURS}/${date_path}

INPUT_PATH=${ADN_DSP_PATH}/${date_path}

check_await "${INPUT_PATH}/virginia/23/_SUCCESS"

BUSINESS="dsp_req"

OUTPUT_PATH=${ID_MAPPING}/${date_path}/${BUSINESS}

spark-submit --class mobvista.dmp.datasource.id_mapping.DspReq \
  --name "EtlDeviceIdDaily.$BUSINESS.$LOG_TIME" \
  --conf spark.yarn.executor.memoryOverhead=2048 \
  --conf spark.network.timeout=720s \
  --conf spark.sql.shuffle.partitions=5000 \
  --conf spark.default.parallelism=5000 \
  --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
  --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 12g --executor-cores 5 --num-executors 200 \
  ../${JAR} -date ${LOG_TIME} -business ${BUSINESS} -output ${OUTPUT_PATH} -coalesce 1000

if [ $? -ne 0 ]; then
  exit 255
fi

common_mount_partition "dwd" "dwd_device_ios_ids_inc_daily" "dt='${LOG_TIME}',active_type='${BUSINESS}'" "${OUTPUT_PATH}/ios"

common_mount_partition "dwd" "dwd_device_android_ids_inc_daily" "dt='${LOG_TIME}',active_type='${BUSINESS}'" "${OUTPUT_PATH}/android"
