#!/usr/bin/env bash

source ../dmp_env.sh
source ././../ga_rawdata_analysis/common/tools.sh

dt_today=$(date -d "$ScheduleTime" +"%Y%m%d")
dt_oneday_ago=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
dt_dash_today=$(date -d "$ScheduleTime" +"%Y-%m-%d")
dt_slash_today=$(date -d "$ScheduleTime" +"%Y/%m/%d")
dt_slash_oneday=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")
check_await "${DM_INSTALL_LIST}_v2/${dt_slash_oneday}/dsp_req/_SUCCESS"

#com.qiyi.video_oppo在dsp_req分区，com.iqiyi.foractivation在iqiyi_activation分区，两者交集生成伪包名com.iqiyi.foractivation_qiyi_oppo
OUTPUT_PATH="${TMP_DEVICEID}/${dt_slash_today}/foractivation_qiyi_oppo"

hadoop fs -rm -r "${OUTPUT_PATH}"

spark-submit --class mobvista.dmp.datasource.iqiyi.EtlOtherIqiyiActivationData \
 --conf spark.network.timeout=720s \
 --conf spark.default.parallelism=2000 \
 --conf spark.sql.shuffle.partitions=2000 \
 --conf spark.sql.broadcastTimeout=1200 \
 --conf spark.sql.autoBroadcastJoinThreshold=31457280 \
 --master yarn --deploy-mode cluster  --executor-memory 12g --driver-memory 4g  --executor-cores 5  --num-executors 80 \
 ../${JAR}  \
 -output ${OUTPUT_PATH} \
 -dt_today ${dt_today} -dt_oneday_ago ${dt_oneday_ago}


if [ $? -ne 0 ];then
  exit 255
fi

mount_partition "dm_install_list_v2_tmp_deviceid" "dt='${dt_today}', device_type='foractivation_qiyi_oppo'" "${OUTPUT_PATH}"

if [ $? -ne 0 ];then
  exit 255
fi

HIVE_CMD=$(hive_func)

$HIVE_CMD	-v  -hivevar  dt_today ${dt_today}     -hivevar update_date ${dt_dash_today}  -f foractivation_qiyi_oppo.sql

if [ $? -ne 0 ];then
  exit 255
fi

DMP_INSTALL_LIST_OUTPUT_PATH="${DM_INSTALL_LIST}_v2/${dt_slash_today}/iqiyi_activation"
hadoop fs -touchz ${DMP_INSTALL_LIST_OUTPUT_PATH}/_SUCCESS

echo "good job~~"
