#!/bin/bash

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime" +"%Y%m%d")
date_path=$(date -d "$ScheduleTime" +"%Y/%m/%d")

yesterday_path=$(date +"%Y/%m/%d" -d "-1 day ${LOG_TIME}")

business="iqiyi_api"

DAILY_INPUT="${IQiYi_DAILY_PATH}/${date_path}"
check_await "${DAILY_INPUT}/_SUCCESS"

sleep 60

INPUT_PATH="${DMP_INSTALL_LIST}/${yesterday_path}/${business}"
check_await "${INPUT_PATH}/_SUCCESS"

OUTPUT="${DMP_INSTALL_LIST}/${date_path}/${business}"

mount_partition "dmp_install_list" "dt='$LOG_TIME', business='$business'" "$OUTPUT"

expire_date=$(date +%Y%m%d -d "-8 day $LOG_TIME")
expire_date_path=$(date +"%Y/%m/%d" -d "-8 day ${LOG_TIME}")
EXPIRE_OUTPUT_PATH="${DMP_INSTALL_LIST}/${expire_date_path}/${business}"

spark-submit --class mobvista.dmp.common.InstallListLogic \
     --name "DmpInstallList.${business}.${LOG_TIME}" \
     --conf spark.sql.shuffle.partitions=200 \
     --conf spark.default.parallelism=200 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 10 \
     ../${JAR} -date ${LOG_TIME} -business ${business} -output ${OUTPUT}  -coalesce 40

if [[ $? -ne 0 ]];then
  exit 255
fi

# 删除过期的分区及删除对应路径
unmount_partition "dmp_install_list" "dt='${expire_date}', business='${business}'" "${EXPIRE_OUTPUT_PATH}"