#!/bin/sh

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# @date : 2020-09-10 16:38:51
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date -d "$ScheduleTime 1 days ago" +"%Y%m%d")
date_path=$(date -d "$ScheduleTime 1 days ago" +"%Y/%m/%d")

INPUT="${IQiYi_LAHUO_DAILY_PATH}/$date_path"

host="ip-172-31-20-35.ec2.internal"
cluster="cluster_1st"
database="dwh"
table="iqiyi_lahuo_daily"

spark-submit --class mobvista.dmp.datasource.iqiyi.IQiYiLaHuoCK \
     --name "IQiYiLaHuoCK.${LOG_TIME}" \
     --conf spark.sql.shuffle.partitions=100 \
     --conf spark.default.parallelism=100 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --conf hive.exec.orc.default.stripe.size=268435456 \
     --conf spark.sql.files.maxPartitionBytes=268435456 \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 10 \
     ../${JAR} -input ${INPUT} -date ${LOG_TIME} -host ${host} -cluster ${cluster} -database ${database} -table ${table}

if [[ $? -ne 0 ]];then
  exit 255
fi