#!/bin/sh

source ../dmp_env.sh

REGION=$1
today=${ScheduleTime:-$2}
LOG_TIME=$(date -d "$today 1 days ago" +"%Y%m%d")
date_path=$(date -d "$today 1 days ago" +"%Y/%m/%d")

INPUT_PATH="s3://mob-emr-test/dataplatform/data/joypac/user_info/${date_path}"

check_await ${INPUT_PATH}/_SUCCESS

sleep 60

spark-submit --class mobvista.dmp.datasource.retargeting.UserFeatureCassandra \
    --name "UserFeatureCassandra.${LOG_TIME}.${REGION}" \
    --conf spark.sql.shuffle.partitions=1000 \
    --conf spark.default.parallelism=1000 \
    --conf spark.yarn.executor.memoryOverhead=2048 \
    --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
    --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 2 --num-executors 3 \
    ../${JAR} -input ${INPUT_PATH} -region ${REGION}

if [[ $? -ne 0 ]];then
  exit 255
fi