#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @author  :fengliang
# @revision:2017-09-01
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")
date_path=$(date +%Y/%m/%d -d "-1 day $ScheduleTime")

INPUT_PATH="${DM_INSTALL_LIST}/$date_path/mp"
OUTPUT_PATH="${DM_INSTALL_LIST}_v2/$date_path/mp"

check_await ${INPUT_PATH}/_SUCCESS

hadoop fs -rm -r $OUTPUT_PATH

reduce_num=`calculate_reduce_num "${INPUT_PATH}"`


hadoop jar ../${JAR} mobvista.dmp.main.ParseInstallRCFile $INPUT_PATH $OUTPUT_PATH ${reduce_num}

if [ $? -ne 0 ];then
  exit 255
fi

: '
business="mp"
spark-submit --class mobvista.dmp.datasource.dm.DmInstallListOrc \
     --name "mobvista.dmp.datasource.dm.DmInstallListOrc.${business}" \
     --conf spark.yarn.executor.memoryOverhead=2048 \
     --conf spark.default.parallelism=500 \
     --conf spark.speculation=true \
     --conf spark.speculation.quantile=0.8 \
     --conf spark.speculation.multiplier=1.2 \
     --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 4g  --executor-cores 3  --num-executors 80 \
     ../${JAR}
     -output ${OUTPUT_PATH} -input ${INPUT_PATH} -business ${business}
'

if [ $? -ne 0 ];then
  exit 255
fi



mount_partition "dm_install_list_v2" "dt='$LOG_TIME', business='mp'" "$OUTPUT_PATH"
if [ $? -ne 0 ];then
  exit 255
fi