#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# # # # # # # # # # # # # # # # # # # # # #

source ../../dmp_env.sh

dt=$(date +"%Y%m%d" -d "-1 day $ScheduleTime")
date_path=$(date +"%Y/%m/%d" -d "-1 day $ScheduleTime")

check_await ${APP_TAG_PATH}/${date_path}/_SUCCESS

OUTPUT_PATH="${OUTPUT_REYUN_APP_TAG_PATH}/${date_path}"

spark-submit --class mobvista.dmp.output.reyun.AppTagDaily \
  --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g --executor-cores 2 --num-executors 2 \
  ../../${JAR} -date ${dt} -output ${OUTPUT_PATH} -coalesce 4

if [ $? -ne 0 ]; then
  exit 255
fi
