#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# # # # # # # # # # # # # # # # # # # # # #

source ../../dmp_env.sh

dt=$(date +"%Y%m%d" -d "-1 day $ScheduleTime")
date_path=$(date +"%Y/%m/%d" -d "-1 day $ScheduleTime")

OUTPUT_PATH="${OUTPUT_REYUN_NEW_TAG_INFO_PATH}/${date_path}"

spark-submit --class mobvista.dmp.output.reyun.NewTagInfoDaily \
  --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g --executor-cores 2 --num-executors 2 \
  ../../${JAR} -date ${dt} -output ${OUTPUT_PATH} -coalesce 4

if [ $? -ne 0 ]; then
  exit 255
fi
