#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# # # # # # # # # # # # # # # # # # # # # #

source ../../dmp_env.sh

dt=$(date +"%Y%m%d" -d "-1 day $ScheduleTime")
date_path=$(date +"%Y/%m/%d" -d "-1 day $ScheduleTime")

check_await ${DMP_EVENT_TAG_DAILY}/day=${dt}/tag_source=3s/_SUCCESS
check_await ${DMP_EVENT_TAG_DAILY}/day=${dt}/tag_source=tp/tag_type=other_purchase/_SUCCESS

OUTPUT_PATH="${OUTPUT_REYUN_EVENT_PATH}/${date_path}"

spark-submit --class mobvista.dmp.output.reyun.EventDaily \
  --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g --executor-cores 2 --num-executors 5 \
  ../../${JAR} -date ${dt} -output ${OUTPUT_PATH} -coalesce 10

if [ $? -ne 0 ]; then
  exit 255
fi
