#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @author : wangjf
# # # # # # # # # # # # # # # # # # # # # #

source ../../dmp_env.sh

dt=$(date +"%Y%m%d" -d "-1 day $ScheduleTime")
date_path=$(date +"%Y/%m/%d" -d "-1 day $ScheduleTime")

check_await ${ODS_DMP_USER_INFO_DAILY}/${dt}/_SUCCESS

OUTPUT_PATH="${OUTPUT_REYUN_USER_INFO_PATH}/${date_path}"

spark-submit --class mobvista.dmp.output.reyun.UserInfo \
  --master yarn --deploy-mode cluster --executor-memory 6g --driver-memory 4g --executor-cores 3 --num-executors 100 \
  ../../${JAR} -date ${dt} -output ${OUTPUT_PATH} -coalesce 1000

if [ $? -ne 0 ]; then
  exit 255
fi
