#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :package_mapping.sh
# @desc    :package_name ID化
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")

date_path=$(date +%Y/%m/%d -d "-1 day $today")

mount_path="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/package_mapping/${date_path}"

spark-submit --class mobvista.dmp.datasource.retargeting.PackageMapping \
     --name "PackageMapping.${date}" \
     --conf spark.sql.shuffle.partitions=10 \
     --conf spark.default.parallelism=10 \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 1 --num-executors 1 \
     ../${JAR} \
     -output ${mount_path}

if [[ $? -ne 0 ]]; then
    exit 255
fi

mount_partition "package_mapping" "dt='${date}'" "${mount_path}"