#!/bin/bash

source ../dmp_env.sh

today=${ScheduleTime:-$2}
date=$(date +"%Y%m%d" -d "-1 day $today")
region=$1

date_path=$(date +%Y/%m/%d -d "-1 day $today")
# ODS_USER_INFO_PATH="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_user_info/${date_path}"

ODS_USER_INFO_REGION_PATH="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dm_user_info_region/${date_path}/${region}"

check_await "${ODS_USER_INFO_REGION_PATH}/_SUCCESS"

sleep 60

if [[ ${region} == "cn" ]]; then
    partition=500
    cores=2
else
    partition=4000
    cores=3
fi

spark-submit --class mobvista.dmp.datasource.retargeting.UserFeatureCassandra \
     --name "mobvista.dmp.datasource.retargeting.UserFeatureCassandra_wangjf_${date}_${region}" \
     --conf spark.sql.shuffle.partitions=${partition} \
     --conf spark.default.parallelism=${partition} \
     --conf spark.sql.files.maxPartitionBytes=33554432 \
     --conf spark.sql.adaptive.enabled=true \
     --conf spark.sql.adaptive.advisoryPartitionSizeInBytes=536870912 \
     --conf spark.yarn.executor.memoryOverhead=2048 \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --master yarn --deploy-mode cluster --executor-memory 2g --driver-memory 2g --executor-cores 2 --num-executors ${cores} \
     ../${JAR} \
     -date ${date} -region ${region} -input ${ODS_USER_INFO_REGION_PATH}

if [[ $? -ne 0 ]]; then
    exit 255
fi