#!/bin/bash

source ../dmp_env.sh

region=$1

spark-submit --class mobvista.dmp.datasource.retargeting.RetargetingCassandra \
     --name "mobvista.dmp.datasource.retargeting.RetargetingCassandra_wangjf_${region}" \
     --conf spark.sql.shuffle.partitions=10 \
     --conf spark.default.parallelism=10 \
     --conf spark.sql.adaptive.enabled=true \
     --conf spark.sql.adaptive.advisoryPartitionSizeInBytes=16777216 \
     --conf spark.yarn.executor.memoryOverhead=2048 \
     --conf spark.driver.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --master yarn --deploy-mode cluster --executor-memory 2g --driver-memory 2g  --executor-cores 2 --num-executors 2 \
     ../${JAR} -region ${region}

if [[ $? -ne 0 ]]; then
    exit 255
fi