#!/bin/bash

source ../dmp_env.sh

today=${ScheduleTime:-$1}

date=$(date +"%Y%m%d" -d "-1 day $today")

date_path=$(date +"%Y/%m/%d/" -d "-1 day $today")

INPUT_PATH="${DMP_INSTALL_LIST}/$date_path/day"

check_await ${INPUT_PATH}/_SUCCESS

OUTPUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dev/device_info_daily/${date_path}"

spark-submit --class mobvista.dmp.datasource.rtdmp.DeviceInfoCalc \
     --name "DeviceInfoCalc.${date}" \
     --conf spark.sql.shuffle.partitions=4000 \
     --conf spark.default.parallelism=4000 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --master yarn --deploy-mode cluster --executor-memory 6g --driver-memory 4g  --executor-cores 4  --num-executors 100 \
     ../${JAR} -date ${date} -output ${OUTPUT}

if [[ $? -ne 0 ]]; then
    exit 255
fi