#!/bin/bash

source ../dmp_env.sh

today=${ScheduleTime:-$1}

date=$(date +"%Y%m%d" -d "-1 day $today")

date_path=$(date +"%Y/%m/%d/" -d "-1 day $today")

INPUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dev/device_region_daily/${date_path}"

OUTPUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/dmp_device_region/${date_path}"

spark-submit --class mobvista.dmp.datasource.rtdmp.DeviceRegionMerge \
     --name "DeviceRegionMerge.wangjf.${date}" \
     --conf spark.sql.shuffle.partitions=1000 \
     --conf spark.default.parallelism=1000 \
     --conf spark.kryoserializer.buffer.max=256m \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --master yarn --deploy-mode cluster --executor-memory 4g --driver-memory 4g  --executor-cores 2  --num-executors 50 \
     ../${JAR} -date ${date} -output ${OUTPUT} -input ${INPUT} -coalesce 200

if [[ $? -ne 0 ]]; then
    exit 255
fi

mount_partition "dmp_device_region" "dt='${date}'" "$OUTPUT"