#!/bin/bash

source ../../dmp_env.sh

today=${ScheduleTime}

date=$(date +"%Y%m%d" -d "-1 day $today")

date_path=$(date +"%Y/%m/%d" -d "-1 day $today")

OUTPUT="s3://mob-emr-test/dataplatform/rtdmp_request/${date_path}/lazada"

spark-submit --class mobvista.dmp.datasource.rtdmp.lazada.ProcessRTJob \
  --name "ProcessRTJob.${date}" \
  --conf spark.sql.shuffle.partitions=4000 \
  --conf spark.default.parallelism=4000 \
  --conf spark.kryoserializer.buffer.max=256m \
  --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
  --master yarn --deploy-mode cluster --executor-memory 6g --driver-memory 4g --executor-cores 4 --num-executors 5 \
  ../../${JAR} -dt ${date} -output ${OUTPUT}

if [[ $? -ne 0 ]]; then
  exit 255
fi
