#!/bin/bash

source ../../dmp_env.sh

today=${ScheduleTime}

date=$(date +"%Y%m%d" -d "-1 day $today")

date_path=$(date +"%Y/%m/%d/" -d "-1 day $today")

OUTPUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/merge_adn_tracking_event/${date_path}"

old_date_path=$(date +"%Y/%m/%d/" -d "-2 day $today")

OLD_OUTPUT="s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/merge_adn_tracking_event/${old_date_path}"

check_await "$OLD_OUTPUT/_SUCCESS"

spark-submit --class mobvista.dmp.datasource.rtdmp.lazada.MergeEventJob \
  --name "MergeInstallJob.${date}" \
  --conf spark.sql.shuffle.partitions=4000 \
  --conf spark.default.parallelism=4000 \
  --conf spark.kryoserializer.buffer.max=256m \
  --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
  --master yarn --deploy-mode cluster --executor-memory 6g --driver-memory 4g --executor-cores 4 --num-executors 5 \
  ../../${JAR} -dt ${date} -output ${OUTPUT}

if [[ $? -ne 0 ]]; then
  exit 255
fi

mount_partition "merge_adn_tracking_event" "dt='${date}'" "$OUTPUT"
