#!/bin/bash

source ../dmp_env.sh

today=${ScheduleTime}
date=$(date +%Y-%m-%d -d "-1 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")

OUTPUT="s3://mob-emr-test/dataplatform/rtdmp_request/${date_path}/install"

spark-submit --class mobvista.dmp.datasource.rtdmp.RTDmpRequestDaily \
  --name "RTDmpRequestDaily.${date}.install" \
  --conf spark.sql.shuffle.partitions=2000 \
  --conf spark.default.parallelism=2000 \
  --conf spark.kryoserializer.buffer.max=256m \
  --conf spark.sql.adaptive.enabled=true \
  --conf spark.sql.adaptive.advisoryPartitionSizeInBytes=268435456 \
  --master yarn --deploy-mode cluster --executor-memory 10g --driver-memory 4g --executor-cores 3 --num-executors 100 \
  ../${JAR} -date "${date}" -output ${OUTPUT} -coalesce 200

if [[ $? -ne 0 ]]; then
  exit 255
fi
