#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :dm_device_tag_statistics.sh
# @desc    :设备不同标签数量
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

today=${ScheduleTime:-$1}
date=$(date +"%Y%m%d" -d "-1 day $today")
unmount_date=$(date +"%Y%m%d" -d "-4 day $today")
date_path=$(date +%Y/%m/%d -d "-1 day $today")
umount_date=$(date +"%Y/%m/%d" -d "-4 day $today")
mount_path="${DM_DEVICE_TAG_STATISTICS_PATH}/${date_path}"
unmount_path="${DM_DEVICE_TAG_STATISTICS_PATH}/${umount_date}"

# interest_path="${DMP_DEVICE_TAG_PATH}/${date_path}"
# check_await ${interest_path}/manual/3s/_SUCCESS
# check_await ${interest_path}/manual/adn_install/_SUCCESS
# check_await ${interest_path}/manual/adn_request_other/_SUCCESS
# check_await ${interest_path}/manual/adn_request_sdk/_SUCCESS
# check_await ${interest_path}/manual/adn_sdk/_SUCCESS
# check_await ${interest_path}/manual/clever/_SUCCESS
# check_await ${interest_path}/manual/dsp_req/_SUCCESS
# check_await ${interest_path}/dc/dsp_req/_SUCCESS

check_await ${DMP_DEVICE_TAG_PATH}/${date_path}/manual/14days/_SUCCESS

spark-submit --class mobvista.dmp.datasource.dm.DmDeviceTagStatistics \
     --name "DmDeviceTagStatistics.${date}" \
     --conf spark.sql.shuffle.partitions=10000 \
     --conf spark.default.parallelism=2000 \
     --conf spark.sql.files.maxPartitionBytes=268435456 \
     --conf spark.executor.extraJavaOptions="-XX:+UseG1GC" \
     --conf spark.sql.adaptive.enabled=true \
     --conf spark.sql.adaptive.advisoryPartitionSizeInBytes=268435456 \
     --master yarn --deploy-mode cluster --executor-memory 18g --driver-memory 4g  --executor-cores 5  --num-executors 60 \
     ../${JAR} \
     -output ${mount_path} -date ${date} -coalesce 500

if [[ $? -ne 0 ]]; then
    exit 255
fi

mount_partition "dmp_device_tag_statistics" "dt='${date}'" "${mount_path}"

unmount_partition "dmp_device_tag_statistics" "dt='${unmount_date}'" "${unmount_path}"

if [[ $? -ne 0 ]]; then
    exit 255
fi