#!/bin/sh

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "-1 day $ScheduleTime")

yes_bef1_slack=$(date +%Y/%m/%d -d "-1 day $ScheduleTime")
yes_bef2_slack=$(date +%Y/%m/%d -d "-2 day $ScheduleTime")

check_await ${DMP_INSTALL_LIST}/${yes_bef1_slack}/adn_request_sdk/_SUCCESS
# check_await ${DMP_INSTALL_LIST}/${yes_bef1_slack}/reyun/_SUCCESS
check_await ${DMP_INSTALL_LIST}/${yes_bef1_slack}/dsp_req/_SUCCESS
check_await ${DMP_INSTALL_LIST}/${yes_bef2_slack}/other/_SUCCESS
check_await ${DMP_INSTALL_LIST}/${yes_bef1_slack}/adn_install/_SUCCESS

OUTPUT_PATH="s3://mob-emr-test/dataplatform/DataWareHouse/data/device_mapping/${yes_bef1_slack}"

spark-submit --class mobvista.dmp.datasource.device.DeviceIDMappingLower \
  --name "DeviceIDMappingLower.${date}.wangjf" \
  --conf spark.network.timeout=720s \
  --conf spark.sql.shuffle.partitions=5000 \
  --conf spark.default.parallelism=5000 \
  --conf spark.sql.files.maxPartitionBytes=536870912 \
  --conf spark.kryoserializer.buffer.max=512m \
  --conf spark.kryoserializer.buffer=64m \
  --conf spark.serializer=org.apache.spark.serializer.KryoSerializer \
  --master yarn \
  --deploy-mode cluster \
  --executor-memory 10G \
  --driver-memory 6G \
  --executor-cores 4 \
  --num-executors 50 \
  ../${JAR} \
  -date ${LOG_TIME} -output ${OUTPUT_PATH} -coalesce 400

if [[ $? -ne 0 ]]; then
  exit 255
fi
