#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file  : zarola_install_daily.sh
# @author: liushaui
# @date  : 17-03-14
# # # # # # # # # # # # # # # # # # # # # #

source ../dmp_env.sh

LOG_TIME=$(date +%Y%m%d -d "$ScheduleTime")

year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}
exit 0

INPUT_INSTALL_DAILY_PATH="$ZAROLA_INSTALL_PATH/$year/$month/$day"
OUTPUT="$ZAROLA_INSTALL_OUTPUT/$year/$month/$day"

hadoop fs -rm -r "$OUTPUT"

hadoop jar ../${JAR} mobvista.dmp.datasource.zarola.mapreduce.ZarolaInstallDailyMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    -Dmapreduce.job.reduces=2 \
    "$INPUT_INSTALL_DAILY_PATH" "$OUTPUT" || exit 1
