### dwh数据库
#### 架构图
[传送门](http://note.youdao.com/noteshare?id=1b3b17e76df47d0f9e7bd009b2c3d746)

#### 表说明
1. ods_ga_device_daily  ga每日活跃用户信息，每个日期分区只包含当天的活跃数据
2. ods_ga_device_total  ga全量用户设备信息
 * 每天使用历史数据加当天的数据更新一份新的全量数据保存在当天的日期分区中，历史分区保留历史全量数据。
 * 使用的话只需要使用最新的时间分区
3. ods_ga_install_daily  ga设备每日安装app记录
4. ods_adn_device_total m系统全量用户设备信息
 * 每天使用历史+当天数据更新一份全量数据，历史分区保留历史全量数据
 * 使用的话只需要使用最新的时间分区
5. etl_adn_sdk_request_daily 每天从adn request日志清洗出来的设备和appid and package_name的对应关系
6. etl_adn_install_daily 每天从adn安装日志中清洗出来的设备和包名的对应关系
    * 数据源： ods_adn_trackingnew_install + dim_campaign_list
7. etl_dsp_req_pkg_daily 每天从dsp request日志中清洗出来的设备和pkg的对应关系
 * 数据源： adn_dsp库下的log_adn_dsp_request_hour表
8. etl_dsp_profile_total 每天从dsp request日志中清洗出来的设备相关信息
 * 数据源： adn_dsp库下的log_adn_dsp_request_hour表
9. dim_campaign_list campaign维度数据，每天同步
10. dm_campaign_tag 给campaign打的兴趣标签
11. dm_install_list 设备的安装列表，按设备聚合，按渠道区分
12. dm_interest_tag 设备的兴趣标签，按设备聚合，按渠道区分
13. dim_app_info_ios 从ios app store抓取的应用信息
14. dim_app_info_adr 从google play抓取的应用信息
15. dim_app_tag app信息标签表，包括包名（google play）或id(ios app store)，应用名称，应用商店名称，app类别
16. dim_country_code 国家代码字典表
17. dim_category 应用分类字典表
18. dim_calendar 日历字典表

#### 应用信息抓取

1. 从campaign_list和安装列表中select出所有的package_name
2. 将select出来的包名和现有的已经抓取的应用信息取差集，and 从现有的已经抓取的应用信息中select出信息过期的包名
3. 抓取第二步中select出来的报名，抓取过程如下：
  * 读取包名，从任务槽队列中获取任务槽(taskQueue)，初始化任务信息，放到线程池(pool)中
  * 线程池异步抓取应用信息，将抓取结果放到待分析的队列(AbstractDetailParser.htmlQueue)中
  * 负责分析抓取到的数据的线程(AdrDetailParser,IosDetailParser)从队列中取数据，解析，写入文件
4. 分别将adr和ios的应用信息和已有应用信息做合并(merge_ios and merge_adr)
5. 统一化应用标签信息入表dim_app_tag

#### 源码阅读流程
1. 从job文件入手，理清job之间的相互依赖关系，和每个job所调用的脚本及了解脚本都干了什么。
2. 基本上MR的脚本模式都是一致的，先设定时间，设置输入输出目录，再调用java的MR，将路径通过参数传到MR程序里面，MR执行结束后再挂载hive表分区。
3. 阅读顺序job -> shell -> java mapreduce

#### 开发规范
1. 目录规范：
 * azkaban 调度相关脚本、job信息及job间依赖关系
 * doc 创建表的sql和说明性文档，新增表请务必将建表语句添加到该目录
 * schema 定义表结构的schema文件，若表的SerDe定义为mobvista.dataplatform.text.TextSerde，则需要另定义schema文件，
   并将schema文件上传到s3://mob-emr-test/dataplatform/DataWareHouse/schema/dwh/${table.name}/ 目录下，并在建表语句中通过schema.url属性指定，
   具体例子见schema下的avsc文件
 * src maven规范源码目录
    datasource包下面是按渠道区分的，分别为adn,ga,dsp，与脚本文件的目录结构相对应，mapreduce程序的Java代码文件均以MR结尾。

2. 分区规范：
 * 全量数据表以year,month,day为时间分区，需要区分渠道的话加上type。
   定位到s3上的目录为：s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/${table_name}/${type}/${year}/${month}/${day}
 * daily按天清洗的表统一以date为分区
   定位到s3上的目录为：s3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/${table_name}/${date}

3. 多处使用的目录和函数要统一定义在dmp_env.sh文件中，其他脚本通过source dmp_env.sh的方式来加载变量和函数

4. 需要发布到线上时，执行项目根目录下的package.sh脚本，会在target目录下生成zip包，直接上传到azkaban发布(仅限linux系统)，
    windows系统使用maven打包后，拷贝到azkaban根目录下，和脚本一起打成zip包上传到调度系统。

