CREATE EXTERNAL TABLE `ods_dmp_user_info_v2`(
  `device_id` string COMMENT 'gaid or idfa',
  `device_type` string COMMENT 'gaid or idfa',
  `platform` string COMMENT 'android or ios',
  `country` string COMMENT '',
  `age` string COMMENT 'age range, example 0-17',
  `gender` string COMMENT 'f or m or o',
  `tags` string COMMENT 'tags',
  `package_names` string COMMENT 'package_names',
  `first_req_day` string COMMENT 'first request day [yyyy-mm-dd]',
  `last_req_day` string COMMENT 'last request day [yyyy-mm-dd]')
PARTITIONED BY (
  `dt` string,
  `business` string)
ROW FORMAT SERDE
  'org.apache.hadoop.hive.ql.io.orc.OrcSerde'
STORED AS INPUTFORMAT
  'org.apache.hadoop.hive.ql.io.orc.OrcInputFormat'
OUTPUTFORMAT
  'org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat'
LOCATION
  's3://mob-emr-test/dataplatform/DataWareHouse/data/dwh/ods_dmp_user_info_v2'