#!/bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :app_get_name.sh
# @author  :liushuai
# @revision:2017-03-14 20:09
# @desc    :循环扫描目录查看有没有excel文件，有的话读取，得到app_id，app_name，platform，impression
# # # # # # # # # # # # # # # # # # # # # #


LOG_TIME=$(date +%Y%m%d -d "-2 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}


source ../prd_env.sh

FILE="s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/four/app_name/app.xls"

while :
do
    hadoop fs -test -e ${FILE}
    if [ $? -ne 0 ]; then
        sleep 1h
        continue
    fi
    break
done




hadoop fs -get ${FILE}

java -classpath ../${JAR} mobvista.prd.datasource.table.ReadMAppXls
if [ $? -ne 0 ];then
  exit 255
fi

hadoop fs -rm s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/four/app_name/app.txt
hadoop fs -put app.txt s3://mob-emr-test/liushuai/prd/${year}/${month}/${day}/four/app_name/

rm *.xls