#! /bin/bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :merge_dmp.sh
# @author  :liushuai
# @revision:2017-03-06 10:45
# @desc    :3天前的M系统，dsp，ga数据整合到一起
# # # # # # # # # # # # # # # # # # # # # #

source ../prd_env.sh

LOG_TIME=$(date +%Y%m%d -d "-3 day $ScheduleTime")
year=${LOG_TIME:0:4}
month=${LOG_TIME:4:2}
day=${LOG_TIME:6:2}

hive_cmd "
use dev;
drop table tmp_dmp;
create table if not exists tmp_dmp
as
	select distinct nvl(nvl(a.device_id,b.device_id),c.device_id) device_id,
	nvl(nvl(a.device_type,b.device_type),c.id_type) device_type,
	nvl(nvl(a.country ,b.country),c.country_code) country
	from (
		select device_id,device_type,country
		from dwh.ods_ga_device_total
		where year='${year}' and
			  month='${month}' and
			  day='${day}' and
			  device_id is not null
		) a
	FULL JOIN (
		select device_id,device_type,country
		from dwh.dm_profile_total
		where type='dsp' and
			  year='${year}' and
			  month='${month}' and
			  day='${day}' and
			  device_id is not null
		) b
	on
		a.device_id=b.device_id and a.device_type=b.device_type
	Full JOIN (
		select device_id,id_type,country_code
		from dwh.ods_adn_device_total
		where year='${year}' and
			  month='${month}' and
			  day='${day}' and
			  device_id is not null
		) c
	on
		a.device_id=c.device_id and a.device_type=c.id_type;
"
if [ $? -ne 0 ];then
  exit 255
fi