#!/usr/bin/env bash

# # # # # # # # # # # # # # # # # # # # # #
# @file    :m_count_country_interest.sh
# @author  :liushuai
# @revision:2017-05-17 20:09
# @desc    ：每天的dsp用户的兴趣标签
# # # # # # # # # # # # # # # # # # # # # #

source ../prd_env.sh

echo "ScheduleTime=$ScheduleTime"
LOG_TIME=$(date +%Y%m%d -d "-2 days $ScheduleTime")

date_path=${LOG_TIME:0:4}/${LOG_TIME:4:2}/${LOG_TIME:6:2}

INPUT_PATH="${REQUEST_TMP_PATH}/tmp_m_interest/${date_path}"
OUTPUT_PATH="${REQUEST_PATH}/m_count_interest/$date_path"

#检查文件是否存在
check_await "${INPUT_PATH}/_SUCCESS"

hadoop fs -rm -r $OUTPUT_PATH

hadoop jar ../${JAR} mobvista.prd.datasource.country.interest.mapreduce.CountryInterestCountMR \
    -Dmapreduce.fileoutputcommitter.algorithm.version=2 \
    -input ${INPUT_PATH} \
    -output ${OUTPUT_PATH} \
    -reduceNum 2

if [ $? -ne 0 ]; then
    exit 255
fi
